@if (@CodeSegment == @Batch) @then

@echo off
setlocal

rem Check if no arguments are provided and display help
if "%~1" == "" (
   for /F "skip=2 tokens=1* delims=:" %%a in ('findstr /N "^" "%~F0"') do (
      if "%%b" == "@endHelp" goto :EOF
      echo/%%b
   )
   goto :EOF
)

rem Execute the JScript section
CScript //nologo //E:JScript "%~F0" %*
goto :EOF

@endHelp

Show properties of a WMI class.

wmiClass [/NS:namespace] [*|class [*|property ...] [/WHERE:clause]]

  /NS:namespace     Specify the namespace, defaults to \root\cimv2.
  class             Show property names of the given class.
  class property    Show values of given properties of the class or alias.
  /WHERE:clause     Clause to select property records to process.

List names of all WMI classes
   wmiClass *

List all properties of the given class
   wmiClass Win32_LocalTime

Show values of all properties of the class
   wmiClass Win32_LocalTime *

Show specific values
   wmiClass Win32_LocalTime Year Month Day

Show values from a wmic.exe alias
   wmiClass OS LocalDateTime

Show selected records
   wmiClass Win32_Process ProcessID Name /where:"Name='cmd.exe'"

@end

// JScript section

var args = WScript.Arguments.Unnamed,
    opts = WScript.Arguments.Named,
    namespace = opts.Exists("NS") ? opts.Item("NS") : "\\root\\cimv2",
    wmi  = GetObject("winmgmts:" + namespace),
    clas = args.Item(0), collection, fetch;

function enumerate(collection, fetch) {
    var r = [];
    for (var e = new Enumerator(collection); !e.atEnd(); e.moveNext()) {
        r.push(fetch(e.item()));
    }
    return r;
}

if (clas == "*") {
    collection = wmi.SubclassesOf();
    fetch = function(el) { return el.Path_.Class; };

} else if (args.length == 1) {
    collection = wmi.Get(clas).Properties_;
    fetch = function(el) { return el.Name; };

} else {
    var where = opts.Exists('WHERE') ? " where " + opts.Item('WHERE') : "";
    collection = wmi.ExecQuery("Select * from " + clas + where);

    if ((new Enumerator(collection)).atEnd()) {
        var alias = GetObject("winmgmts:\\root\\cli");
        collection = alias.ExecQuery("Select Target from Msft_CliAlias where FriendlyName='" + clas + "'");
        var e = new Enumerator(collection);
        if (e.atEnd()) {
            WScript.Stderr.WriteLine("Class or alias not exists: " + clas);
            WScript.Quit(1);
        }
        clas = e.item().Target.substr(14);
        collection = wmi.ExecQuery("Select * from " + clas + where);
    }

    var prop = [];
    if (args.Item(1) == "*") {
        prop = enumerate(wmi.Get(clas).Properties_, function(el) { return el.Name; });
    } else {
        for (var i = 1; i < args.length; i++) { prop.push(args.Item(i)); }
    }

    fetch = function(el) {
        var r = [];
        for (var i = 0; i < prop.length; i++) {
            var n = prop[i];
            r.push(n + "=" + el[n]);
        }
        return r.join('\n');
    };
}

WScript.StdOut.WriteLine(enumerate(collection, fetch).join('\n'));
