//
//  EmptyAudioManager.swift
//  MpAccDemo
//

import UIKit
import AVFoundation

class EmptyAudioManager: NSObject {
    static let share = EmptyAudioManager()
    
    private var player: AVAudioPlayer?
    
    private override init() { }
    
    func playEmptyMusic() {
        guard let audioFilePath = Bundle.main.path(forResource: "donot", ofType: "mp3") else { return }
        let audioFileURL = URL(fileURLWithPath: audioFilePath)
        do {
            try setupAudioSession()
            
            player = try AVAudioPlayer(contentsOf: audioFileURL)
            
            player?.numberOfLoops = -1
            
            player?.play()
        } catch {
            print("Failed to initialize audio player: \(error.localizedDescription)")
        }
    }
    
    func stop() {
        player?.stop()
        player = nil
    }
    
    private func setupAudioSession() throws {
        let audioSession = AVAudioSession.sharedInstance()
        // 设置音频会话类别为播放和录音
        try audioSession.setActive(false)
        try audioSession.setCategory(.playback, mode: .default)
        try audioSession.setActive(true)
    }
}
