//
//  ChartRttData.swift
//  MpAccDemo
//
//  Created by Robin on 2024/12/30.
//

import UIKit
import Combine
import DGCharts

class ChartRttData {
    class OrgRttData {
        @Published private var wifi: Int = 0
        @Published private var mobile: Int = 0
        @Published private var acc: Int = 0
        
        var accRttUpdate: AnyPublisher<(Int, Int, Int), Never> {
            Publishers.CombineLatest3($wifi, $mobile, $acc).debounce(for: 0.3, scheduler: RunLoop.main).eraseToAnyPublisher()
        }
        
        func updateRtt(_ rtt: Int, type: Int) {
            if type == 0 {
                mobile = rtt
            } else if type == 1 {
                wifi = rtt
            } else if type == 2 {
                acc = rtt
            }
        }
    }

    
    let orgRttData: OrgRttData = OrgRttData()
    
    private var wifiRtts: [ChartDataEntry] = []
    private var mobileRtts: [ChartDataEntry] = []
    private var accRtts: [ChartDataEntry] = []
    
    private weak var chartView: LineChartView?
    
    private lazy var wifiSet: LineChartDataSet = {
        let set = LineChartDataSet(entries: self.wifiRtts, label: "wifi")
        set.drawCirclesEnabled = false
        set.setColor(.red)
        return set
    }()
    
    private lazy var mobileSet: LineChartDataSet = {
        let set = LineChartDataSet(entries: self.mobileRtts, label: "mobile")
        set.drawCirclesEnabled = false
        set.setColor(.yellow)
        return set
    }()
    
    private lazy var accSet: LineChartDataSet = {
        let set = LineChartDataSet(entries: self.mobileRtts, label: "acc")
        set.drawCirclesEnabled = false
        set.setColor(.green)
        return set
    }()
    
    private var cancellable: AnyCancellable?
    
    private var index: Int = 100
    
    init() {
        for idx in 0...99 {
            wifiRtts.append(ChartDataEntry(x: Double(idx), y: 0))
            mobileRtts.append(ChartDataEntry(x: Double(idx), y: 0))
            accRtts.append(ChartDataEntry(x: Double(idx), y: 0))
        }
    }
    
    func bindDataToChartView(_ chartView: LineChartView) {
        self.chartView = chartView
        self.cancellable = self.orgRttData.accRttUpdate.sink { (wifi, mobile, acc) in
            self.wifiRtts.append(ChartDataEntry(x: Double(self.index), y: Double(wifi)))
            self.mobileRtts.append(ChartDataEntry(x: Double(self.index), y: Double(mobile)))
            self.accRtts.append(ChartDataEntry(x: Double(self.index), y: Double(acc)))
            
            self.wifiRtts.removeFirst()
            self.mobileRtts.removeFirst()
            self.accRtts.removeFirst()
            
            self.index += 1
            
            self.updateData()
        }
    }
    
    private func updateData() {
        self.wifiSet.replaceEntries(self.wifiRtts)
        self.mobileSet.replaceEntries(self.mobileRtts)
        self.accSet.replaceEntries(self.accRtts)
        self.chartView?.data = LineChartData(dataSets: [self.wifiSet, self.mobileSet, self.accSet])
    }
}

