//
//  ViewController.swift
//  MpAccDemo
//

import UIKit
//import FLEX

struct TestItem {
    let image: UIImage
    let title: String
    var pageId: String = ""
    var pageClass: UIViewController.Type? = nil
    var store: Bool = true
}

class ViewController: UITableViewController {

//    override func motionEnded(_ motion: UIEvent.EventSubtype, with event: UIEvent?) {
//        if motion == .motionShake {
//            FLEXManager.shared.showExplorer()
//        }
//    }
    
    private let items = [
        TestItem(image: UIImage(systemName: "s.circle")!, title: "socks5", pageId: "Socks5ViewController"),
    ]

    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return items.count
    }
    
    let cellIdentifier = "reuseIdentifier"
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)

        if cell == nil {
            cell = UITableViewCell(style: .default, reuseIdentifier: cellIdentifier)
        }
        if #available(iOS 14.0, *) {
            var config = UIListContentConfiguration.cell()
            config.image = items[indexPath.row].image
            config.text = items[indexPath.row].title
            cell?.contentConfiguration = config
        } else {
            cell?.textLabel?.text = items[indexPath.row].title
            cell?.imageView?.image = items[indexPath.row].image
        }
        return cell!
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let item = items[indexPath.row];
        let page: UIViewController
        if item.store {
            let story = UIStoryboard(name: "Main", bundle: nil)
            page = story.instantiateViewController(withIdentifier: items[indexPath.row].pageId)
        } else {
            page = item.pageClass!.init();
        }
        self.navigationController?.pushViewController(page, animated: true)
    }

}

