//
//  MenuTextField.swift
//  MpAccDemo
//
//  Created by Robin on 2023/10/16.
//

import UIKit

class MenuTextField: UITextField, ConfigItemViewProtocol {
    static func newItem() -> ConfigItemViewProtocol {
        let field = MenuTextField()
        field.delegate = field
        field.textAlignment = .center
        field.font = .systemFont(ofSize: 20)
        field.borderStyle = .roundedRect
        field.addConstraint(field.widthAnchor.constraint(greaterThanOrEqualToConstant: 100))
        return field
    }
    
    var currentItem: MpItem!
    
    var itemList: [MpItem]!
    
    var saveBlock: ((MpItem) -> Void)?
    
    var changedBlock: ((MpItem) -> Void)?
    
    func currentItemDidChanged() {
        self.text = self.currentItem.title
    }
    
    func itemListChanged() { }
}

extension MenuTextField: UITextFieldDelegate {
    func textFieldDidEndEditing(_ textField: UITextField) {
        self.currentItem.title = textField.text!
    }
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        return true
    }
}
