//
//  MenuSwitch.swift
//  MpAccDemo
//
//  Created by Robin on 2023/10/16.
//

import UIKit

class MenuSwitch: UISwitch, ConfigItemViewProtocol {
    static func newItem() -> ConfigItemViewProtocol {
        let menuSwitch = MenuSwitch()
        menuSwitch.addTarget(MenuSwitch.self, action: #selector(MenuSwitch.valueChanged), for: .valueChanged)
        return menuSwitch
    }
    
    var currentItem: MpItem!
    
    var itemList: [MpItem]!
    
    var saveBlock: ((MpItem) -> Void)?
    
    var changedBlock: ((MpItem) -> Void)?
    
    func currentItemDidChanged() {
        self.isOn = self.currentItem.on
    }
    
    func itemListChanged() { }
    

    @objc static func valueChanged(_ sender: MenuSwitch) {
        sender.currentItem.on = sender.isOn
    }

}
