//
//  ViewController.m
//  MpAccDemo-OC
//
//  Created by 房彤 on 2025/7/3.
//

#import "ViewController.h"
#import <MpAccSDK/MpAccSDK-Swift.h>
@interface ViewController () <AccCallback, MpMeasureCallback>
@property (nonatomic, weak) IBOutlet UIButton *startBtn;
@property (nonatomic, weak) IBOutlet UIButton *stopBtn;
@property (nonatomic, weak) IBOutlet UIButton *preRegisterBtn;
@property (nonatomic, assign) NSInteger port;
@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.port = 3000; //TODO: 设置本地可用端口
    [MpAccClient.shared setAccType:AccTypeSocks5];
    [MpAccClient.shared setupDatakey:@"xxx" uuid:@"xxx"];

}

// 开始加速
- (IBAction)start:(id)sender {
    [MpAccClient.shared registerAccCallback:self];
    
    AccConfig *config = [[AccConfig alloc] init];
    config.accMode = AccModeBonding;
    config.pingInterval = 3;
    config.socksProxyPort = self.port;
    //设置T2开关
    [config setBool:YES forKey:AccConfig.KEY_ENABLE_T2ACC];
    //设置指定下车点
    [config setString:@"xx" forKey:AccConfig.KEY_T2OUT];
    
    [MpAccClient.shared startWithConfig:config];
}

// 停止加速
- (IBAction)stop:(id)sender {
    [MpAccClient.shared stop];
    [MpAccClient.shared unRegisterAccCallback:self];
    //TODO: 流量切回
}

// 预注册
- (IBAction)registerAcc:(id)sender {
    [MpAccClient.shared registerWithMode:AccModeBonding completion:^(NSError * _Nullable error) {
        if (!error) {
            NSLog(@"注册成功");
        } else {
            NSLog(@"注册失败： %@", error);
        }
    }];
}


#pragma mark - AccCallback
//加速成功回调
- (void)onAccSuccessWithIp:(NSString *)ip port:(NSInteger)port {
    NSLog(@"加速成功，ip:%@, port:%ld", ip, (long)port);
    //TODO: 切流
}

//加速失败回调
- (void)onAccFail:(NSError *)error {
    NSLog(@"加速失败，%@", error);
}

//网络速率回调
- (void)onAccDataUpdateWithTRx:(int64_t)tRx tTx:(int64_t)tTx pathDetails:(NSArray<MpPathDetail *> *)pathDetails {
    NSLog(@"Data updated: tRx = %lld, tTx = %lld", tRx, tTx);
    for (MpPathDetail *detail in pathDetails) {
        NSLog(@"Path detail: %@", detail);
    }
}

//加速汇总信息更新
- (void)onSummaryInfoUpdate:(NSString *)summaryInfo {
    NSLog(@"SummaryInfo: %@", summaryInfo);
}

//网卡链路状态变化回调
- (void)onNetworkStateChanged:(enum MpInterfaceType)type available:(BOOL)available ip:(NSString *)ip {
    
}



@end
