package com.android.myproject;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;

import com.android.linkboost.multi.socks.Socks5;
import com.android.linkboost.multi.socks.Socks5Datagram;
import com.android.linkboost.multi.socks.SocksProxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;

import okhttp3.OkHttpClient;

/**
 * socks模式加速demo
 */
public class SocksExampleActivity extends Activity implements View.OnClickListener {
    private static final String TAG = "MPACC";

    private ApiTest mApiTest;

    @Override protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }

    @Override protected void onStart() {
        super.onStart();
        initView();
        initMpAcc();
    }

    private void initView() {
        Button startQos = findViewById(R.id.start_acc);
        Button stopQos = findViewById(R.id.stop_acc);
        Button startTest = findViewById(R.id.start_test);
        startQos.setOnClickListener(this);
        stopQos.setOnClickListener(this);
        startTest.setOnClickListener(this);
    }

    private void initMpAcc() {
        //腾讯云申请的datakey需传入
        ApiTest.setDataKey("test-123456", "*");
        mApiTest = ApiTest.getInstance(this);
    }

    private void startSocksAcc() {
        mApiTest.registerAccCallback();
        mApiTest.startSocksAcc();
    }

    private void stopSocksAcc() {
        mApiTest.stopAcc();
        mApiTest.unregisterAccCallback();
    }

    @Override public void onClick(View v) {
        int id = v.getId();
        switch (id) {
            case R.id.start_acc:
                startSocksAcc();
                break;
            case R.id.stop_acc:
                stopSocksAcc();
                break;
            case R.id.start_test:
                new Thread(this::testUdpSocks).start();
                break;
        }
    }

    private void testUdpSocks() {
        try {
            Log.i(TAG, "start testUdp");
            //端口需和setSocksPort传入的一致
            SocksProxy socksProxy = new Socks5(new InetSocketAddress("localhost", ApiTest.PORT));
            DatagramSocket clientSocket = new Socks5Datagram(socksProxy);
            String message = "Hi, I am UDP client";
            byte[] sendBuffer = message.getBytes();
            DatagramPacket packet = new DatagramPacket(sendBuffer, sendBuffer.length,
                    new InetSocketAddress("106.55.119.181", 8888));
            clientSocket.send(packet);
            //Received response message from UDP server.
            byte[] receiveBuf = new byte[100];
            DatagramPacket receivedPacket = new DatagramPacket(receiveBuf, receiveBuf.length);
            clientSocket.receive(receivedPacket);
            String receiveStr = new String(receivedPacket.getData(), 0, receivedPacket.getLength());
            Log.i(TAG, "testUdp: " + receiveStr);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void testHttpSocks() {
        BufferedReader buff = null;
        HttpURLConnection urlConnection = null;
        try {
            Proxy socksProxy =
                    new Proxy(Proxy.Type.SOCKS, new InetSocketAddress("127.0.0.1", ApiTest.PORT));
            URL url = new URL("url");
            urlConnection = (HttpURLConnection) url.openConnection(socksProxy);
            //....
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void testOkHttp() {
        Proxy socksProxy =
                new Proxy(Proxy.Type.SOCKS, new InetSocketAddress("127.0.0.1", ApiTest.PORT));
        OkHttpClient client = new OkHttpClient.Builder().proxy(socksProxy).build();
        //....
    }

    private void testSocket() {
        Proxy socksProxy =
                new Proxy(Proxy.Type.SOCKS, new InetSocketAddress("127.0.0.1", ApiTest.PORT));
        Socket socket = new Socket(socksProxy);
        //...
    }
}
