package com.android.myproject;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;

import androidx.annotation.NonNull;

import com.android.linkboost.multi.MpNetworkPlugin;
import com.android.linkboost.multi.MpNetworkPluginManager;
import com.android.linkboost.multi.log.MpAccLog;

public class MpNetworkPluginImpl extends MpNetworkPlugin {
    private static final String TAG = "MpNetworkPluginImpl";
    private static final String WLAN1 = "wlan1";
    private final ConnectivityManager mConnectivityManager;
    private final MpNetworkPluginManager mMpNetworkPluginManager;
    private final InnerCallback mInnerCallback;

    public MpNetworkPluginImpl(Context context) {
        super(context);
        mConnectivityManager =
                (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        mMpNetworkPluginManager = new MpNetworkPluginManager(context);
        mInnerCallback = new InnerCallback();
    }

    @Override public void requestNetwork() {
        NetworkRequest.Builder req = new NetworkRequest.Builder();
        req.addCapability(NetworkCapabilities.NET_CAPABILITY_INTERNET);
        req.addTransportType(NetworkCapabilities.TRANSPORT_WIFI);
        mConnectivityManager.registerNetworkCallback(req.build(), mInnerCallback);
    }

    @Override public void releaseNetwork() {
        mConnectivityManager.unregisterNetworkCallback(mInnerCallback);
    }

    class InnerCallback extends ConnectivityManager.NetworkCallback {
        @Override public void onLinkPropertiesChanged(@NonNull Network network,
                @NonNull LinkProperties linkProperties) {
            super.onLinkPropertiesChanged(network, linkProperties);
            MpAccLog.i(TAG, "onLinkPropertiesChanged:"
                    + network
                    + " ifname:"
                    + linkProperties.getInterfaceName());
            if (WLAN1.equals(linkProperties.getInterfaceName())) {
                // 不同linkProperties.getInterfaceName()网卡名，传不同type
                // if (ETH0.equals(linkProperties.getInterfaceName())) {
                // type = 101;// type() 自定义type大于100小于1000 （100-1000），避免和其他系统网卡冲突
                int type = 101;
                mMpNetworkPluginManager.onLinkPropertiesChanged(type, network, linkProperties);
            }
        }

        @Override public void onLost(@NonNull Network network) {
            super.onLost(network);
            MpAccLog.i(TAG, "onLost:" + network);
            mMpNetworkPluginManager.onLost(network);
        }
    }
}
