package com.android.myproject;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;

import androidx.annotation.Nullable;

/**
 * vpn加速模式demo
 */
public class ExampleActivity extends Activity implements View.OnClickListener {
    private static final int VPN_REQUEST_CODE = 0x0F;
    private ApiTest mApiTest;

    @Override protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }

    @Override protected void onStart() {
        super.onStart();
        initView();
        initMpAcc();
    }

    private void initView() {
        Button startAcc = findViewById(R.id.start_acc);
        Button stopAcc = findViewById(R.id.stop_acc);
        startAcc.setOnClickListener(this);
        stopAcc.setOnClickListener(this);
    }

    private void initMpAcc() {
        //腾讯云申请的datakey需传入
        ApiTest.setDataKey("test-123456", "*");
        mApiTest = ApiTest.getInstance(this);
    }

    private void startVpn() {
        mApiTest.registerAccCallback();
        //权限认证
        Intent vpnIntent = ApiTest.prepare(this);
        if (vpnIntent != null) {
            startActivityForResult(vpnIntent, VPN_REQUEST_CODE);
        } else {
            onActivityResult(VPN_REQUEST_CODE, RESULT_OK, null);
        }
    }

    private void stopVpn() {
        mApiTest.stopAcc();
        mApiTest.unregisterAccCallback();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == VPN_REQUEST_CODE && resultCode == RESULT_OK) {
            mApiTest.startAcc();
        }
    }

    @Override public void onClick(View v) {
        int id = v.getId();
        switch (id) {
            case R.id.start_acc:
                startVpn();
                break;
            case R.id.stop_acc:
                stopVpn();
                break;
        }
    }
}
