package com.android.myproject;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import com.android.linkboost.multi.AccCallback;
import com.android.linkboost.multi.AccConfig;
import com.android.linkboost.multi.MpAccClient;
import com.android.linkboost.multi.PathDetail;
import com.android.linkboost.multi.exception.MpAccSDKException;

import java.util.ArrayList;

public class ApiTest {
    private static final String TAG = "ApiTest";
    public static final int PORT = 18080;
    private final AccCallback mAccCallback;
    private final MpAccClient mMpAccClient;
    private static volatile ApiTest mApiTest;

    public static ApiTest getInstance(Context context) {
        if (null == mApiTest) {
            synchronized (ApiTest.class) {
                if (null == mApiTest) {
                    mApiTest = new ApiTest(context);
                }
            }
        }
        return mApiTest;
    }

    public static void setDataKey(String deviceId, String datakey) {
        MpAccClient.setDataKey(deviceId, datakey);
    }

    public static Intent prepare(Activity activity) {
        return MpAccClient.prepare(activity);
    }

    private ApiTest(Context context) {
        mAccCallback = new InnerAccCallback();
        mMpAccClient = MpAccClient.getInstance(context);
    }

    /**
     * 发起加速，vpn模式，调用此接口前需用户通过vpn权限
     */
    public void startAcc() {
        AccConfig accConfig = new AccConfig();
        ArrayList<String> list = new ArrayList<>();
        accConfig.setAccMode(2);   //1:聚合加速  2：双发加速  3：快切加速
        accConfig.setRoute("0.0.0.0", 0); //加速ip列表
        //添加自定义网卡插件
        //accConfig.addNetworkPlugin("com.android.myproject.SocksExampleActivity");
        //list.add("air.tv.douyu.android");  //传入需要加速的包名,不传默认对所有应用加速
        accConfig.setWhiteList(list, 0);
        try {
            mMpAccClient.startAcc(accConfig);
        } catch (MpAccSDKException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 发起加速，socks模式
     */
    public void startSocksAcc() {
        AccConfig accConfig = new AccConfig();
        accConfig.setAccMode(3)  //1:聚合加速  2：双发加速  3：快切加速
                .setPingInterval(3).setEnableSocks(true).setSocksPort(PORT);
        try {
            mMpAccClient.startAcc(accConfig);
        } catch (MpAccSDKException e) {
            e.printStackTrace();
        }
    }

    /**
     * 停止加速
     */
    public void stopAcc() {
        try {
            mMpAccClient.stopAcc();
        } catch (MpAccSDKException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 注册加速状态回调监听
     */
    public void registerAccCallback() {
        try {
            mMpAccClient.registerAccCallback(mAccCallback);
        } catch (MpAccSDKException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 注销加速状态回调监听
     */
    public void unregisterAccCallback() {
        try {
            mMpAccClient.unregisterAccCallback(mAccCallback);
        } catch (MpAccSDKException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 加速状态回调监听类
     */
    public static class InnerAccCallback implements AccCallback {

        @Override
        public void onAccDataUpdate(long tRx, long tTx, ArrayList<PathDetail> pathDetails) {
            Log.i(TAG, "tRx" + tRx + " tTx:" + tTx + " pathDetailS:" + pathDetails);
        }

        @Override public void onSummaryInfoUpdate(String s) {
            Log.i(TAG, "onSummaryInfoUpdate: " + s);
        }

        @Override public void onAccSuccess(ArrayList<String> packageNames, String var2, int var3) {
            Log.d(TAG, "onAccSuccess" + " ip:" + var2 + " 端口:" + var3);
        }

        @Override public void onNetworkStateChanged(int type, boolean available, String ip) {
            Log.i(TAG, "onNetworkStateChanged: type:"
                    + type
                    + " available:"
                    + available
                    + " ip:"
                    + ip);
        }

        @Override public void onAccFail(ArrayList<String> packageNames, int errorCode) {
            Log.d(TAG, "onAccFail: " + errorCode);
        }
    }
}
